/*
 * Decompiled with CFR 0.152.
 */
package com.recordingblogs.sound.asio;

import com.recordingblogs.sound.asio.AsioSampleType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AsioChannel {
    private final int index;
    private final boolean isInput;
    private volatile boolean isActive;
    private final int channelGroup;
    private final AsioSampleType sampleType;
    private final String name;
    private final ByteBuffer[] nativeBuffers;
    private volatile int bufferIndex;
    private static final float MAX_INT16 = 32767.0f;
    private static final float MAX_INT18 = 131071.0f;
    private static final float MAX_INT20 = 524287.0f;
    private static final float MAX_INT24 = 8388607.0f;
    private static final float MAX_INT32 = 2.1474836E9f;

    private AsioChannel(int n, boolean bl, boolean bl2, int n2, AsioSampleType asioSampleType, String string) {
        this.index = n;
        this.isInput = bl;
        this.isActive = bl2;
        this.channelGroup = n2;
        this.sampleType = asioSampleType;
        this.name = string;
        this.nativeBuffers = new ByteBuffer[2];
    }

    public int getChannelIndex() {
        return this.index;
    }

    public boolean isInput() {
        return this.isInput;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getChannelGroup() {
        return this.channelGroup;
    }

    public AsioSampleType getSampleType() {
        return this.sampleType;
    }

    public String getChannelName() {
        return this.name;
    }

    public ByteBuffer getByteBuffer() {
        return this.nativeBuffers[this.bufferIndex];
    }

    protected void setBufferIndex(int n) {
        this.bufferIndex = n;
        this.nativeBuffers[n].rewind();
    }

    protected void setByteBuffers(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer == null || byteBuffer2 == null) {
            this.isActive = false;
            this.nativeBuffers[0] = null;
            this.nativeBuffers[1] = null;
        } else {
            this.nativeBuffers[0] = this.isInput ? byteBuffer.asReadOnlyBuffer() : byteBuffer;
            ByteBuffer byteBuffer3 = this.nativeBuffers[1] = this.isInput ? byteBuffer2.asReadOnlyBuffer() : byteBuffer2;
            if (this.sampleType.name().contains("MSB")) {
                this.nativeBuffers[0].order(ByteOrder.BIG_ENDIAN);
                this.nativeBuffers[1].order(ByteOrder.BIG_ENDIAN);
            } else {
                this.nativeBuffers[0].order(ByteOrder.LITTLE_ENDIAN);
                this.nativeBuffers[1].order(ByteOrder.LITTLE_ENDIAN);
            }
            this.isActive = true;
        }
    }

    public void write(float[] fArray) {
        if (this.isInput) {
            throw new IllegalStateException("Only output channels can be written to");
        }
        if (!this.isActive) {
            throw new IllegalStateException("This channel is not active: " + this.toString());
        }
        ByteBuffer byteBuffer = this.getByteBuffer();
        switch (this.sampleType) {
            case ASIOSTFloat64MSB: 
            case ASIOSTFloat64LSB: {
                for (float f : fArray) {
                    byteBuffer.putDouble(f);
                }
                break;
            }
            case ASIOSTFloat32MSB: 
            case ASIOSTFloat32LSB: {
                for (float f : fArray) {
                    byteBuffer.putFloat(f);
                }
                break;
            }
            case ASIOSTInt32MSB: 
            case ASIOSTInt32LSB: {
                for (float f : fArray) {
                    byteBuffer.putInt((int)(f * 2.1474836E9f));
                }
                break;
            }
            case ASIOSTInt32MSB16: 
            case ASIOSTInt32LSB16: {
                for (float f : fArray) {
                    byteBuffer.putInt((int)(f * 32767.0f));
                }
                break;
            }
            case ASIOSTInt32MSB18: 
            case ASIOSTInt32LSB18: {
                for (float f : fArray) {
                    byteBuffer.putInt((int)(f * 131071.0f));
                }
                break;
            }
            case ASIOSTInt32MSB20: 
            case ASIOSTInt32LSB20: {
                for (float f : fArray) {
                    byteBuffer.putInt((int)(f * 524287.0f));
                }
                break;
            }
            case ASIOSTInt32MSB24: 
            case ASIOSTInt32LSB24: {
                for (float f : fArray) {
                    byteBuffer.putInt((int)(f * 8388607.0f));
                }
                break;
            }
            case ASIOSTInt16MSB: 
            case ASIOSTInt16LSB: {
                for (float f : fArray) {
                    byteBuffer.putShort((short)(f * 32767.0f));
                }
                break;
            }
            case ASIOSTInt24MSB: {
                for (float f : fArray) {
                    int n = (int)(f * 8388607.0f);
                    byteBuffer.put((byte)(n >> 16 & 0xFF));
                    byteBuffer.put((byte)(n >> 8 & 0xFF));
                    byteBuffer.put((byte)(n & 0xFF));
                }
                break;
            }
            case ASIOSTInt24LSB: {
                for (float f : fArray) {
                    int n = (int)(f * 8388607.0f);
                    byteBuffer.put((byte)(n & 0xFF));
                    byteBuffer.put((byte)(n >> 8 & 0xFF));
                    byteBuffer.put((byte)(n >> 16 & 0xFF));
                }
                break;
            }
            default: {
                throw new IllegalStateException("The sample types ASIOSTDSDInt8MSB1, ASIOSTDSDInt8LSB1, and ASIOSTDSDInt8NER8 are not supported");
            }
        }
    }

    public void read(float[] fArray) {
        if (!this.isInput) {
            throw new IllegalStateException("Only input channels can be read from");
        }
        if (!this.isActive) {
            throw new IllegalStateException("This channel is not active: " + this.toString());
        }
        ByteBuffer byteBuffer = this.getByteBuffer();
        switch (this.sampleType) {
            case ASIOSTFloat64MSB: 
            case ASIOSTFloat64LSB: {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)byteBuffer.getDouble();
                }
                break;
            }
            case ASIOSTFloat32MSB: 
            case ASIOSTFloat32LSB: {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = byteBuffer.getFloat();
                }
                break;
            }
            case ASIOSTInt32MSB: 
            case ASIOSTInt32LSB: {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)byteBuffer.getInt() / 2.1474836E9f;
                }
                break;
            }
            case ASIOSTInt32MSB16: 
            case ASIOSTInt32LSB16: {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)byteBuffer.getInt() / 32767.0f;
                }
                break;
            }
            case ASIOSTInt32MSB18: 
            case ASIOSTInt32LSB18: {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)byteBuffer.getInt() / 131071.0f;
                }
                break;
            }
            case ASIOSTInt32MSB20: 
            case ASIOSTInt32LSB20: {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)byteBuffer.getInt() / 524287.0f;
                }
                break;
            }
            case ASIOSTInt32MSB24: 
            case ASIOSTInt32LSB24: {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)byteBuffer.getInt() / 8388607.0f;
                }
                break;
            }
            case ASIOSTInt16MSB: 
            case ASIOSTInt16LSB: {
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = (float)byteBuffer.getShort() / 32767.0f;
                }
                break;
            }
            case ASIOSTInt24MSB: {
                for (int i = 0; i < fArray.length; ++i) {
                    int n = byteBuffer.get() & 0xFFFF;
                    n <<= 8;
                    n |= byteBuffer.get() & 0xFF;
                    n <<= 8;
                    fArray[i] = (float)(n |= byteBuffer.get() & 0xFF) / 8388607.0f;
                }
                break;
            }
            case ASIOSTInt24LSB: {
                for (int i = 0; i < fArray.length; ++i) {
                    int n = byteBuffer.get() & 0xFF;
                    n |= (byteBuffer.get() & 0xFF) << 8;
                    fArray[i] = (float)(n |= (byteBuffer.get() & 0xFFFF) << 16) / 8388607.0f;
                }
                break;
            }
            default: {
                throw new IllegalStateException("The sample types ASIOSTDSDInt8MSB1, ASIOSTDSDInt8LSB1, and ASIOSTDSDInt8NER8 are not supported");
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof AsioChannel)) {
            return false;
        }
        AsioChannel asioChannel = (AsioChannel)object;
        return asioChannel.getChannelIndex() == this.index && asioChannel.isInput() == this.isInput;
    }

    public int hashCode() {
        return this.isInput ? this.index : ~this.index + 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isInput ? "Input" : "Output");
        stringBuilder.append(" Channel ");
        stringBuilder.append(Integer.toString(this.index));
        stringBuilder.append(": ");
        stringBuilder.append(this.name);
        stringBuilder.append(", ");
        stringBuilder.append(this.sampleType.toString());
        stringBuilder.append(", group ");
        stringBuilder.append(Integer.toString(this.channelGroup));
        stringBuilder.append(", ");
        stringBuilder.append(this.isActive ? "active" : "inactive");
        return stringBuilder.toString();
    }
}

