/*
 * Decompiled with CFR 0.152.
 */
package com.recordingblogs.oreffect;

import com.recordingblogs.oreffect.AutomationEvent;
import com.recordingblogs.oreffect.AutomationListener;
import com.recordingblogs.oreffect.AutomationPoint;
import com.recordingblogs.oreffect.ReadInterface;
import com.recordingblogs.oreffect.WriteInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Automation
extends Vector<AutomationPoint> {
    private static final long serialVersionUID = 1L;
    private String m_title;
    private float m_minimum;
    private float m_maximum;
    private String m_displayLabel;
    private int m_displayDecimals;
    private boolean m_isActive;
    private transient int m_current;
    private transient List<AutomationListener> m_listeners;

    public Automation() {
        super(0);
        this.add(new AutomationPoint(0.0f, 0.0f));
        this.add(new AutomationPoint(0.0f, 0.0f));
        this.m_title = "Automation";
        this.m_minimum = -1.0f;
        this.m_maximum = 1.0f;
        this.m_displayLabel = "";
        this.m_displayDecimals = 0;
        this.m_current = 0;
        this.m_listeners = new ArrayList<AutomationListener>();
        this.m_isActive = false;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public float getMinimum() {
        return this.m_minimum;
    }

    public void setMinimum(float f) {
        this.m_minimum = f;
    }

    public float getMaximum() {
        return this.m_maximum;
    }

    public void setMaximum(float f) {
        this.m_maximum = f;
    }

    @Override
    public synchronized AutomationPoint get(int n) {
        if (this.size() <= 0) {
            return null;
        }
        if (n < 0) {
            return (AutomationPoint)super.get(0);
        }
        if (n >= this.size()) {
            return (AutomationPoint)super.get(this.size() - 1);
        }
        return (AutomationPoint)super.get(n);
    }

    @Override
    public synchronized AutomationPoint remove(int n) {
        if (n <= 0) {
            return null;
        }
        if (n >= this.size() - 1) {
            return null;
        }
        return (AutomationPoint)super.remove(n);
    }

    public String getDisplayLabel() {
        return this.m_displayLabel;
    }

    public void setDisplayLabel(String string) {
        this.m_displayLabel = string;
    }

    public int getDisplayDecimals() {
        return this.m_displayDecimals;
    }

    public void setDisplayDecimals(int n) {
        this.m_displayDecimals = n;
    }

    public float getValueAt(double d) {
        if (d < (double)this.get(0).getX()) {
            return this.get(0).getY();
        }
        if (d > (double)this.get(this.size() - 1).getX()) {
            return this.get(this.size() - 1).getY();
        }
        if (this.m_current < 0) {
            this.m_current = 0;
        }
        if (this.m_current >= this.size()) {
            this.m_current = this.size() - 1;
        }
        while (this.m_current >= 0 && d < (double)this.get(this.m_current).getX()) {
            --this.m_current;
        }
        while (this.m_current < this.size() - 1 && d > (double)this.get(this.m_current + 1).getX()) {
            ++this.m_current;
        }
        double d2 = 0.0;
        if (this.m_current >= 0 && this.m_current < this.size() - 1) {
            if (this.get(this.m_current).getX() == this.get(this.m_current + 1).getX()) {
                d2 = this.get(this.m_current).getY();
            }
            d2 = (double)this.get(this.m_current + 1).getY() - ((double)this.get(this.m_current + 1).getX() - d) * (double)(this.get(this.m_current + 1).getY() - this.get(this.m_current).getY()) / (double)(this.get(this.m_current + 1).getX() - this.get(this.m_current).getX());
        }
        return (float)((double)(this.m_minimum + (this.m_maximum - this.m_minimum) / 2.0f) + d2 * (double)(this.m_maximum - this.m_minimum) / 2.0);
    }

    public void setEqual(Automation automation) {
        if (automation.getClass() != this.getClass()) {
            System.out.println("Error in Automation::setEqual: Error in class");
            return;
        }
        if (automation == this) {
            return;
        }
        this.removeAllElements();
        this.m_minimum = automation.m_minimum;
        this.m_maximum = automation.m_maximum;
        this.m_current = automation.m_current;
        this.m_displayLabel = automation.m_displayLabel;
        this.m_displayDecimals = automation.m_displayDecimals;
        for (int i = 0; i < automation.size(); ++i) {
            this.insertElementAt(new AutomationPoint(automation.get(i).getX(), automation.get(i).getY()), i);
        }
    }

    public boolean getIsActive() {
        return this.m_isActive;
    }

    public void setIsActive(boolean bl) {
        if (this.m_isActive == bl) {
            return;
        }
        this.m_isActive = bl;
        for (AutomationListener automationListener : this.m_listeners) {
            automationListener.automationActivated(new AutomationEvent(this, this.m_isActive));
        }
    }

    public void setTimeEnd(double d) {
        for (int i = this.size() - 1; i > 1; --i) {
            if (!((double)this.get(i - 1).getX() >= d) || !(d > 0.0)) continue;
            this.remove(i);
        }
        if (this.size() > 0) {
            this.get(this.size() - 1).setX((float)d);
        }
    }

    public void addAutomationListener(AutomationListener automationListener) {
        this.m_listeners.add(automationListener);
    }

    public List<AutomationListener> getAutomationListeners() {
        return this.m_listeners;
    }

    public boolean save(WriteInterface writeInterface) {
        try {
            writeInterface.writeFloat(this.m_minimum);
            writeInterface.writeFloat(this.m_maximum);
            writeInterface.writeString(this.m_displayLabel);
            writeInterface.writeInt(this.m_displayDecimals);
            writeInterface.writeBoolean(this.m_isActive);
            writeInterface.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                writeInterface.writeDouble(this.get(i).getX());
                writeInterface.writeDouble(this.get(i).getY());
            }
        }
        catch (IOException iOException) {
            System.out.println("Exception in Automation::writeObject: " + String.valueOf(iOException));
            return false;
        }
        return true;
    }

    public boolean read(ReadInterface readInterface) {
        try {
            this.m_minimum = readInterface.readFloat();
            this.m_maximum = readInterface.readFloat();
            this.m_displayLabel = readInterface.readString();
            this.m_displayDecimals = readInterface.readInt();
            this.m_isActive = readInterface.readBoolean();
            this.removeAllElements();
            int n = readInterface.readInt();
            for (int i = 0; i < n; ++i) {
                AutomationPoint automationPoint = new AutomationPoint((float)readInterface.readDouble(), (float)readInterface.readDouble());
                this.add(automationPoint);
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            System.out.println("Exception in Automation::readObject: " + String.valueOf(exception));
            return false;
        }
        return true;
    }
}

