/*
 * Decompiled with CFR 0.152.
 */
package com.recordingblogs.sound.asio;

import com.recordingblogs.sound.asio.AsioChannel;
import com.recordingblogs.sound.asio.AsioDriverInfo;
import com.recordingblogs.sound.asio.AsioDriverListener;
import com.recordingblogs.sound.asio.AsioDriverState;
import com.recordingblogs.sound.asio.AsioException;
import java.io.File;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JOptionPane;

public class AsioDriver {
    public static boolean ASIO_AVAIABLE = false;
    private AsioDriverState currentState;
    private final List<AsioDriverListener> listeners;
    private final Set<AsioChannel> activeChannels;
    private final AsioChannel[] inputChannels;
    protected final AsioChannel[] outputChannels;
    private final AsioDriverInfo driverInfo;
    private static AsioDriver asioDriver;
    private static final Set<Thread> registeredThreads;

    protected AsioDriver(String string) {
        int n;
        AsioDriver.registerThreadIfNecessary();
        boolean bl = false;
        if (AsioDriver.isDriverLoaded()) {
            if (!string.equals(asioDriver.getName())) {
                JOptionPane.showMessageDialog(null, "Cannot load more than one driver", "Error", 0);
                throw new AsioException("More than one driver");
            }
            bl = true;
        } else {
            bl = AsioDriver.loadDriver(string);
        }
        if (!bl) {
            throw new AsioException("The driver was not successfully loaded. ASIO does not indicate why");
        }
        this.driverInfo = this.ASIOInit();
        this.currentState = AsioDriverState.INITIALIZED;
        this.activeChannels = new HashSet<AsioChannel>();
        asioDriver = this;
        this.listeners = new ArrayList<AsioDriverListener>();
        this.inputChannels = new AsioChannel[AsioDriver.ASIOGetChannels(true)];
        for (n = 0; n < this.inputChannels.length; ++n) {
            this.inputChannels[n] = AsioDriver.ASIOGetChannelInfo(n, true);
        }
        this.outputChannels = new AsioChannel[AsioDriver.ASIOGetChannels(false)];
        for (n = 0; n < this.outputChannels.length; ++n) {
            this.outputChannels[n] = AsioDriver.ASIOGetChannelInfo(n, false);
        }
    }

    public static AsioDriver getDriver(String string) {
        if (string == null) {
            throw new NullPointerException("The driver name cannot be null");
        }
        if (AsioDriver.isDriverLoaded()) {
            if (string.equals(asioDriver.getName())) {
                return asioDriver;
            }
            asioDriver.shutdownAndUnloadDriver();
        }
        if (AsioDriver.getDriverNames().contains(string)) {
            asioDriver = new AsioDriver(string);
            return asioDriver;
        }
        throw new IllegalArgumentException("The driver name does not exist in the system registry. Check AsioDriver.getDriverNames()");
    }

    private static void registerThreadIfNecessary() {
        if (registeredThreads.isEmpty()) {
            registeredThreads.add(Thread.currentThread());
        } else if (!registeredThreads.contains(Thread.currentThread())) {
            registeredThreads.add(Thread.currentThread());
            AsioDriver.registerThread();
        }
    }

    private static native boolean registerThread();

    public static AsioDriver getCurrentDriver() {
        return asioDriver;
    }

    public static boolean isDriverLoaded() {
        return asioDriver != null;
    }

    public static List<String> getDriverNames() {
        AsioDriver.registerThreadIfNecessary();
        String[] stringArray = new String[32];
        int n = AsioDriver.getDriverNames(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    private static native int getDriverNames(String[] var0);

    public AsioDriverInfo getInfo() {
        return this.driverInfo;
    }

    public String getName() {
        return this.driverInfo.getDriverName();
    }

    public int getVersion() {
        return this.driverInfo.getDriverVersion();
    }

    public int getAsioVersion() {
        return this.driverInfo.getAsioVersion();
    }

    public synchronized AsioDriverState getCurrentState() {
        return this.currentState;
    }

    private native AsioDriverInfo ASIOInit();

    public synchronized void exit() {
        if (!AsioDriverState.INITIALIZED.equals((Object)this.currentState)) {
            throw new IllegalStateException("AsioDriver must be in AsioDriverState.INITIALIZED state in order to be initialised. The current state is: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        this.ASIOExit();
        this.currentState = AsioDriverState.LOADED;
    }

    private native void ASIOExit();

    public synchronized void openControlPanel() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIOControlPanel();
    }

    private static native void ASIOControlPanel();

    public int getNumChannelsInput() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        return this.inputChannels.length;
    }

    public int getNumChannelsOutput() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        return this.outputChannels.length;
    }

    private static native int ASIOGetChannels(boolean var0);

    public synchronized double getSampleRate() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetSampleRate();
    }

    private static native double ASIOGetSampleRate();

    public synchronized boolean canSampleRate(double d) {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOCanSampleRate(d);
    }

    private static native boolean ASIOCanSampleRate(double var0);

    public synchronized void setSampleRate(double d) {
        if (this.currentState.ordinal() != AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIOSetSampleRate(d);
    }

    private static native void ASIOSetSampleRate(double var0);

    public synchronized int getBufferMinSize() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetBufferSize(0);
    }

    public synchronized int getBufferMaxSize() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetBufferSize(1);
    }

    public synchronized int getBufferPreferredSize() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetBufferSize(2);
    }

    public synchronized int getBufferGranularity() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetBufferSize(3);
    }

    private static native int ASIOGetBufferSize(int var0);

    public synchronized int getLatencyInput() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetLatencies(true);
    }

    public synchronized int getLatencyOutput() {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        AsioDriver.registerThreadIfNecessary();
        return AsioDriver.ASIOGetLatencies(false);
    }

    private static native int ASIOGetLatencies(boolean var0);

    public synchronized AsioChannel getChannelInput(int n) {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        if (n < 0 || n >= this.inputChannels.length) {
            throw new IndexOutOfBoundsException("The input index must be in [0," + Integer.toString(this.inputChannels.length) + "): " + Integer.toString(n));
        }
        return this.inputChannels[n];
    }

    public synchronized AsioChannel getChannelOutput(int n) {
        if (this.currentState.ordinal() < AsioDriverState.INITIALIZED.ordinal()) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        if (n < 0 || n >= this.outputChannels.length) {
            throw new IndexOutOfBoundsException("The output index must be in [0," + Integer.toString(this.outputChannels.length) + "): " + Integer.toString(n));
        }
        return this.outputChannels[n];
    }

    private static native AsioChannel ASIOGetChannelInfo(int var0, boolean var1);

    public synchronized void createBuffers(Set<AsioChannel> set) {
        if (!AsioDriverState.INITIALIZED.equals((Object)this.currentState)) {
            throw new IllegalStateException("The AsioDriver must be at least in the INITIALIZED state: " + this.currentState.toString());
        }
        if (set == null) {
            throw new NullPointerException("The set of channels to initialize may not be null");
        }
        if (set.contains(null)) {
            throw new IllegalArgumentException("The set of channels to initialize may not contain a null value");
        }
        if (set.size() == 0) {
            throw new IllegalArgumentException("The set of channels to initialize may not be empty");
        }
        this.activeChannels.addAll(set);
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIOCreateBuffers(this.activeChannels.toArray(new AsioChannel[0]), this.getBufferPreferredSize());
        this.currentState = AsioDriverState.PREPARED;
        int n = this.getBufferPreferredSize();
        if (n <= 0) {
            throw new AsioException("The driver was not successfully loaded. Incorrect preferred buffer size");
        }
    }

    private static native void ASIOCreateBuffers(AsioChannel[] var0, int var1);

    public synchronized void disposeBuffers() {
        if (!AsioDriverState.PREPARED.equals((Object)this.currentState)) {
            throw new IllegalStateException("The ASIO driver must be in the PREPARED state in order to dispose of the audio buffers");
        }
        for (AsioChannel asioChannel : this.activeChannels) {
            asioChannel.setByteBuffers(null, null);
        }
        this.activeChannels.clear();
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIODisposeBuffers();
        this.currentState = AsioDriverState.INITIALIZED;
    }

    private static native void ASIODisposeBuffers();

    public synchronized void start() {
        if (!AsioDriverState.PREPARED.equals((Object)this.currentState)) {
            throw new IllegalStateException();
        }
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIOStart();
        this.currentState = AsioDriverState.RUNNING;
    }

    private static native void ASIOStart();

    public synchronized void stop() {
        if (!AsioDriverState.RUNNING.equals((Object)this.currentState)) {
            throw new IllegalStateException();
        }
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.ASIOStop();
        this.currentState = AsioDriverState.PREPARED;
    }

    private static native void ASIOStop();

    private static native boolean loadDriver(String var0);

    private synchronized void unloadDriver() {
        if (!AsioDriverState.LOADED.equals((Object)this.currentState)) {
            throw new IllegalStateException();
        }
        AsioDriver.registerThreadIfNecessary();
        AsioDriver.removeCurrentDriver();
        this.currentState = AsioDriverState.UNLOADED;
        asioDriver = null;
    }

    private static native void removeCurrentDriver();

    public synchronized void shutdownAndUnloadDriver() {
        this.returnToState(AsioDriverState.UNLOADED);
    }

    public synchronized void returnToState(AsioDriverState asioDriverState) {
        if (asioDriverState == null) {
            throw new NullPointerException("Target state may not be null");
        }
        if (asioDriverState.ordinal() < this.currentState.ordinal()) {
            switch (this.currentState) {
                case RUNNING: {
                    this.stop();
                    if (this.currentState.equals((Object)asioDriverState)) break;
                }
                case PREPARED: {
                    this.disposeBuffers();
                    if (this.currentState.equals((Object)asioDriverState)) break;
                }
                case INITIALIZED: {
                    this.exit();
                    if (this.currentState.equals((Object)asioDriverState)) break;
                }
                case LOADED: {
                    this.unloadDriver();
                    break;
                }
            }
        }
    }

    public synchronized void addAsioDriverListener(AsioDriverListener asioDriverListener) {
        if (this.currentState.ordinal() < AsioDriverState.PREPARED.ordinal()) {
            if (!this.listeners.contains(asioDriverListener)) {
                this.listeners.add(asioDriverListener);
            }
        } else {
            throw new IllegalStateException("AsioDriverListeners can only be updated while the AsioDriver is in the LOADED or INITIALIZED state");
        }
    }

    public synchronized void removeAsioDriverListener(AsioDriverListener asioDriverListener) {
        if (this.currentState.ordinal() >= AsioDriverState.PREPARED.ordinal()) {
            throw new IllegalStateException("AsioDriverListeners can only be updated while the AsioDriver is in the LOADED or INITIALIZED state");
        }
        this.listeners.remove(asioDriverListener);
    }

    private void fireSampleRateDidChange(double d) {
        for (AsioDriverListener asioDriverListener : this.listeners) {
            asioDriverListener.sampleRateDidChange(d);
        }
    }

    private void fireResetRequest() {
        for (AsioDriverListener asioDriverListener : this.listeners) {
            asioDriverListener.resetRequest();
        }
    }

    private void fireResyncRequest() {
        for (AsioDriverListener asioDriverListener : this.listeners) {
            asioDriverListener.resyncRequest();
        }
    }

    private void fireBufferSizeChanged(int n) {
        for (AsioDriverListener asioDriverListener : this.listeners) {
            asioDriverListener.bufferSizeChanged(n);
        }
    }

    private void fireLatenciesChanged(int n, int n2) {
        for (AsioDriverListener asioDriverListener : this.listeners) {
            asioDriverListener.latenciesChanged(n, n2);
        }
    }

    private void fireBufferSwitch(long l, long l2, int n) {
        for (AsioChannel asioChannel : this.inputChannels) {
            if (!asioChannel.isActive()) continue;
            asioChannel.setBufferIndex(n);
        }
        for (AsioChannel asioChannel : this.outputChannels) {
            if (!asioChannel.isActive()) continue;
            asioChannel.setBufferIndex(n);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).bufferSwitch(l, l2, this.activeChannels);
        }
    }

    static {
        String string = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (string.indexOf("wind") >= 0) {
            try {
                File file;
                CodeSource codeSource = AsioDriver.class.getProtectionDomain().getCodeSource();
                File file2 = new File(codeSource.getLocation().toURI().getPath());
                Object object = file2.getParentFile().getPath();
                object = ((String)object).substring(0, ((String)object).lastIndexOf(File.separator));
                if (!((String)object).endsWith(File.separator)) {
                    object = (String)object + File.separator;
                }
                if ((file = new File((String)object + "orinj")).exists()) {
                    object = (String)object + "orinj";
                    object = (String)object + File.separator;
                    object = (String)object + "orinjasio.dll";
                } else {
                    object = (String)object + "app";
                    object = (String)object + File.separator;
                    object = (String)object + "orinjasio.dll";
                }
                System.load((String)object);
                ASIO_AVAIABLE = true;
            }
            catch (Exception | UnsatisfiedLinkError throwable) {
                JOptionPane.showMessageDialog(null, "Cannot load ASIO.  ASIO will not be available", "Error", 0);
                ASIO_AVAIABLE = false;
            }
        }
        registeredThreads = new HashSet<Thread>();
    }
}

